#!/bin/bash

# Runs the Validate External Links script
# Arguments: --help, --links URL, --exceptions URL, --output DIR, --record-ok-links,
# --suggest-snapshots, --take-screenshots, --start-url NUM, --end-url NUM, --upload FILE
# Recommended rule:
# ----------------------------------------------------------------------------------------------

# Set variables for any arguments we might use below
VALEXTLINKS="/path/to/Validate External Links/validate_external_links.sh"
LINKS_LOCAL="file:///path/to/Validate External Links/Sample files/extlinks.csv"
LINKS_ONLINE="http://wiki.oni2.net/w/extlinks.csv"
EXCEPT_LOCAL="file:///path/to/Validate External Links/exceptions.txt"
EXCEPT_ONLINE="http://iritscen.oni2.net/val/exceptions.txt"
REPORT_DIR="/path/to/ValExtLinks reports"
UPLOAD_INFO="/path/to/Validate External Links/sftp_login.txt"


# Run for limited number of URLs, record OK codes, upload
#bash "$VALEXTLINKS" --links "$LINKS_ONLINE" --exceptions "$EXCEPT_ONLINE" --output "$REPORT_DIR" --record-ok-links --suggest-snapshots --end-url 20 --upload "$UPLOAD_INFO"

# Run with local extlinks and start/end URL, record OK codes
#bash "$VALEXTLINKS" --links "$LINKS_LOCAL" --output "$REPORT_DIR" --record-ok-links --suggest-snapshots --start-url 70 --end-url 75

# Normal run
bash "$VALEXTLINKS" --links "$LINKS_ONLINE" --exceptions "$EXCEPT_ONLINE" --output "$REPORT_DIR" --suggest-snapshots --upload "$UPLOAD_INFO"